import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { forwardRef } from 'react';
import { twMerge } from 'tailwind-merge';
import { Spinner, useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { ButtonBase } from './ButtonBase';
import ButtonGroup from './ButtonGroup';
const ButtonComponent = forwardRef(({ children, className, color = 'info', disabled = false, fullSized, isProcessing = false, processingLabel = 'Loading...', processingSpinner: SpinnerComponent = _jsx(Spinner, {}), gradientDuoTone, gradientMonochrome, label, outline = false, pill = false, positionInGroup = 'none', size = 'md', theme: customTheme = {}, ...props }, ref) => {
    const { buttonGroup: groupTheme, button: buttonTheme } = useTheme().theme;
    const theme = mergeDeep(buttonTheme, customTheme);
    const theirProps = props;
    return (_jsx(ButtonBase, { disabled: disabled, ref: ref, className: twMerge(theme.base, disabled && theme.disabled, !gradientDuoTone && !gradientMonochrome && theme.color[color], gradientDuoTone && !gradientMonochrome && theme.gradientDuoTone[gradientDuoTone], !gradientDuoTone && gradientMonochrome && theme.gradient[gradientMonochrome], outline && (theme.outline.color[color] ?? theme.outline.color.default), theme.pill[pill ? 'on' : 'off'], fullSized && theme.fullSized, groupTheme.position[positionInGroup], className), ...theirProps, children: _jsx("span", { className: twMerge(theme.inner.base, theme.outline[outline ? 'on' : 'off'], theme.outline.pill[outline && pill ? 'on' : 'off'], theme.size[size], outline && !theme.outline.color[color] && theme.inner.outline, isProcessing && theme.isProcessing, theme.inner.position[positionInGroup]), children: _jsxs(_Fragment, { children: [isProcessing && _jsx("span", { className: twMerge(theme.spinnerSlot), children: SpinnerComponent }), typeof children !== 'undefined' ? (children) : (_jsx("span", { "data-testid": "flowbite-button-label", className: twMerge(theme.label), children: isProcessing ? processingLabel : label }))] }) }) }));
});
ButtonComponent.displayName = 'Button';
export const Button = Object.assign(ButtonComponent, {
    Group: ButtonGroup,
});
