import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const Card = ({ children, className, horizontal, href, imgAlt, imgSrc, theme: customTheme = {}, ...props }) => {
    const Component = typeof href === 'undefined' ? 'div' : 'a';
    const theirProps = props;
    const theme = mergeDeep(useTheme().theme.card, customTheme);
    return (_jsxs(Component, { "data-testid": "flowbite-card", href: href, className: twMerge(theme.root.base, theme.root.horizontal[horizontal ? 'on' : 'off'], href && theme.root.href, className), ...theirProps, children: [imgSrc && (_jsx("img", { alt: imgAlt ?? '', src: imgSrc, className: twMerge(theme.img.base, theme.img.horizontal[horizontal ? 'on' : 'off']) })), _jsx("div", { className: theme.root.children, children: children })] }));
};
Card.displayName = 'Card';
