import type { ComponentProps, FC, PropsWithChildren, ReactNode } from 'react';
import type { DeepPartial, FlowbiteBoolean } from '../../';
export interface FlowbiteCarouselTheme {
    root: FlowbiteCarouselRootTheme;
    indicators: FlowbiteCarouselIndicatorsTheme;
    item: FlowbiteCarouselItemTheme;
    control: FlowbiteCarouselControlTheme;
    scrollContainer: FlowbiteCarouselScrollContainer;
}
export interface FlowbiteCarouselRootTheme {
    base: string;
    leftControl: string;
    rightControl: string;
}
export interface FlowbiteCarouselIndicatorsTheme {
    active: FlowbiteBoolean;
    base: string;
    wrapper: string;
}
export interface FlowbiteCarouselItemTheme {
    base: string;
    wrapper: string;
}
export interface FlowbiteCarouselControlTheme {
    base: string;
    icon: string;
}
export interface FlowbiteCarouselScrollContainer {
    base: string;
    snap: string;
}
export interface CarouselProps extends PropsWithChildren<ComponentProps<'div'>> {
    indicators?: boolean;
    leftControl?: ReactNode;
    rightControl?: ReactNode;
    slide?: boolean;
    slideInterval?: number;
    theme?: DeepPartial<FlowbiteCarouselTheme>;
    onSlideChange?: (slide: number) => void;
}
export declare const Carousel: FC<CarouselProps>;
