import type { ExtendedRefs, useInteractions } from '@floating-ui/react';
import type { Dispatch, FC, HTMLProps, PropsWithChildren, ReactElement, ReactNode, SetStateAction } from 'react';
import type { ButtonProps, DeepPartial } from '../../';
import type { FloatingProps, FlowbiteFloatingTheme } from '../../components/Floating';
import type { FlowbiteDropdownDividerTheme } from './DropdownDivider';
import type { FlowbiteDropdownHeaderTheme } from './DropdownHeader';
import type { FlowbiteDropdownItemTheme } from './DropdownItem';
export interface FlowbiteDropdownFloatingTheme extends FlowbiteFloatingTheme, FlowbiteDropdownDividerTheme, FlowbiteDropdownHeaderTheme {
    item: FlowbiteDropdownItemTheme;
}
export interface FlowbiteDropdownTheme {
    floating: FlowbiteDropdownFloatingTheme;
    content: string;
    inlineWrapper: string;
    arrowIcon: string;
}
export interface DropdownProps extends PropsWithChildren, Pick<FloatingProps, 'placement' | 'trigger'>, Omit<ButtonProps, 'theme'> {
    arrowIcon?: boolean;
    dismissOnClick?: boolean;
    floatingArrow?: boolean;
    inline?: boolean;
    label: ReactNode;
    theme?: DeepPartial<FlowbiteDropdownTheme>;
    renderTrigger?: (theme: FlowbiteDropdownTheme) => ReactElement;
    'data-testid'?: string;
}
export interface TriggerProps extends Omit<ButtonProps, 'theme'> {
    refs: ExtendedRefs<HTMLElement>;
    inline?: boolean;
    theme: FlowbiteDropdownTheme;
    setButtonWidth?: Dispatch<SetStateAction<number | undefined>>;
    getReferenceProps: (userProps?: HTMLProps<Element> | undefined) => Record<string, unknown>;
    renderTrigger?: (theme: FlowbiteDropdownTheme) => ReactElement;
}
interface DropdownContextValue {
    activeIndex: number | null;
    dismissOnClick?: boolean;
    getItemProps: ReturnType<typeof useInteractions>['getItemProps'];
    handleSelect: (index: number | null) => void;
}
export declare const DropdownContext: import("react").Context<DropdownContextValue>;
export declare const Dropdown: FC<DropdownProps> & {
    Item: FC<import("./DropdownItem").DropdownItemProps>;
    Header: FC<{
        children?: ReactNode;
    } & import("react").ClassAttributes<HTMLDivElement> & import("react").HTMLAttributes<HTMLDivElement>>;
    Divider: FC<import("react").DetailedHTMLProps<import("react").HTMLAttributes<HTMLDivElement>, HTMLDivElement>>;
};
export {};
