import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const FooterDivider = ({ className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.divider, customTheme);
    return _jsx("hr", { "data-testid": "footer-divider", className: twMerge(theme.base, className), ...props });
};
