import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const FooterLink = ({ as: Component = 'a', children, className, href, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.groupLink.link, customTheme);
    return (_jsx("li", { className: twMerge(theme.base, className), children: _jsx(Component, { href: href, className: theme.href, ...props, children: children }) }));
};
