import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const FooterTitle = ({ as: Component = 'h2', className, theme: customTheme = {}, title, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.title, customTheme);
    return (_jsx(Component, { "data-testid": "flowbite-footer-title", className: twMerge(theme.base, className), ...props, children: title }));
};
