import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const HelperText = ({ children, className, color = 'default', theme: customTheme = {}, value, ...props }) => {
    const theme = mergeDeep(useTheme().theme.helperText, customTheme);
    return (_jsx("p", { className: twMerge(theme.root.base, theme.root.colors[color], className), ...props, children: value ?? children ?? '' }));
};
HelperText.displayName = 'HelperText';
