import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { HiOutlineX } from 'react-icons/hi';
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { useModalContext } from './ModalContext';
export const ModalHeader = ({ as: Component = 'h3', children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.modal.header, customTheme);
    const { popup, onClose } = useModalContext();
    return (_jsxs("div", { className: twMerge(theme.base, popup && theme.popup, className), ...props, children: [_jsx(Component, { className: theme.title, children: children }), _jsx("button", { "aria-label": "Close", className: theme.close.base, type: "button", onClick: onClose, children: _jsx(HiOutlineX, { "aria-hidden": true, className: theme.close.icon }) })] }));
};
