import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial, FlowbiteBoolean } from '../../';
import type { FlowbiteNavbarBrandTheme } from './NavbarBrand';
import type { FlowbiteNavbarCollapseTheme } from './NavbarCollapse';
import type { FlowbiteNavbarLinkTheme } from './NavbarLink';
import type { FlowbiteNavbarToggleTheme } from './NavbarToggle';
export interface FlowbiteNavbarTheme {
    root: FlowbiteNavbarRootTheme;
    brand: FlowbiteNavbarBrandTheme;
    collapse: FlowbiteNavbarCollapseTheme;
    link: FlowbiteNavbarLinkTheme;
    toggle: FlowbiteNavbarToggleTheme;
}
export interface FlowbiteNavbarRootTheme {
    base: string;
    rounded: FlowbiteBoolean;
    bordered: FlowbiteBoolean;
    inner: {
        base: string;
        fluid: FlowbiteBoolean;
    };
}
export interface NavbarComponentProps extends PropsWithChildren, ComponentProps<'nav'> {
    menuOpen?: boolean;
    fluid?: boolean;
    rounded?: boolean;
    border?: boolean;
    theme?: DeepPartial<FlowbiteNavbarRootTheme>;
}
export declare const Navbar: FC<NavbarComponentProps> & {
    Brand: FC<import("./NavbarBrand").NavbarBrandProps>;
    Collapse: FC<import("./NavbarCollapse").NavbarCollapseProps>;
    Link: FC<import("./NavbarLink").NavbarLinkProps>;
    Toggle: FC<import("./NavbarToggle").NavbarToggleProps>;
};
