import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const NavbarBrand = ({ as: Component = 'a', children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.navbar.brand, customTheme);
    return (_jsx(Component, { className: twMerge(theme.base, className), ...props, children: children }));
};
