import type { ComponentProps, ElementType, FC, PropsWithChildren } from 'react';
import type { DeepPartial, FlowbiteBoolean } from '../../';
export interface FlowbiteNavbarLinkTheme {
    base: string;
    active: FlowbiteBoolean;
    disabled: FlowbiteBoolean;
}
export interface NavbarLinkProps extends PropsWithChildren, ComponentProps<'a'>, Record<string, unknown> {
    active?: boolean;
    as?: ElementType;
    disabled?: boolean;
    href?: string;
    theme?: DeepPartial<FlowbiteNavbarLinkTheme>;
}
export declare const NavbarLink: FC<NavbarLinkProps>;
