import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { SidebarItemContext } from './SidebarItemContext';
export const SidebarItemGroup = ({ children, className, ...props }) => {
    const theme = useTheme().theme.sidebar.itemGroup;
    return (_jsx("ul", { "data-testid": "flowbite-sidebar-item-group", className: twMerge(theme, className), ...props, children: _jsx(SidebarItemContext.Provider, { value: { isInsideCollapse: false }, children: children }) }));
};
SidebarItemGroup.displayName = 'Sidebar.ItemGroup';
