import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../components/Flowbite';
import { mergeDeep } from '../../helpers/merge-deep';
export const TableBody = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.table.body, customTheme);
    return (_jsx("tbody", { className: twMerge(theme.base, className), ...props, children: children }));
};
