import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const TableHead = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.table, customTheme);
    return (_jsx("thead", { className: twMerge(theme.head.base, className), ...props, children: _jsx("tr", { children: children }) }));
};
