import { type InputMask, type InputMaskElement, type FactoryOpts } from 'imask';
import { Dispatch } from 'react';
import type { MutableRefObject } from 'react';
export default function useIMask<MaskElement extends InputMaskElement, Opts extends FactoryOpts = FactoryOpts>(opts: Opts, { onAccept, onComplete, ref, defaultValue, defaultUnmaskedValue, defaultTypedValue, }?: {
    ref?: MutableRefObject<MaskElement | null>;
    onAccept?: (value: InputMask<Opts>['value'], maskRef: InputMask<Opts>, e?: InputEvent) => void;
    onComplete?: (value: InputMask<Opts>['value'], maskRef: InputMask<Opts>, e?: InputEvent) => void;
    defaultValue?: InputMask<Opts>['value'];
    defaultUnmaskedValue?: InputMask<Opts>['unmaskedValue'];
    defaultTypedValue?: InputMask<Opts>['typedValue'];
}): {
    ref: MutableRefObject<MaskElement | null>;
    maskRef: MutableRefObject<InputMask<Opts> | null>;
    value: InputMask<Opts>['value'];
    setValue: Dispatch<InputMask<Opts>['value']>;
    unmaskedValue: InputMask<Opts>['unmaskedValue'];
    setUnmaskedValue: Dispatch<InputMask<Opts>['unmaskedValue']>;
    typedValue: InputMask<Opts>['typedValue'];
    setTypedValue: Dispatch<InputMask<Opts>['typedValue']>;
};
//# sourceMappingURL=hook.d.ts.map