import React, { CSSProperties, ElementType, HTMLAttributes, MutableRefObject, ReactNode, Ref } from 'react';
import { DefaultScrollOptions, ScrollContainerCustomizedProps, ScrollContainerDefaultProps } from '../types';
interface BasicProps {
    hideScrollbars?: boolean;
    children?: ReactNode;
    className?: string;
    style?: CSSProperties;
    ref?: ReactNode;
    component?: ElementType;
}
declare type CustomizedProps<Options = DefaultScrollOptions> = BasicProps & ScrollContainerCustomizedProps<Options>;
declare type DefaultProps = BasicProps & ScrollContainerDefaultProps;
declare const Body: <Options extends object = DefaultScrollOptions>(props: DefaultProps | CustomizedProps<Options>, ref: Ref<ElementType>) => JSX.Element;
export declare const ScrollContainer: <Options = DefaultScrollOptions, Element_1 = HTMLDivElement>(props: (DefaultProps | CustomizedProps<Options>) & {
    ref?: React.MutableRefObject<Element_1> | undefined;
} & React.HTMLAttributes<Element_1>) => ReturnType<typeof Body>;
export {};
