declare type EventSourceOptions = {
    init?: EventSourceInit;
    event?: string;
};
/**
 * Subscribe to an event source and return the latest event.
 * @param url The URL of the event source to connect to
 * @param options The options to pass to the EventSource constructor
 * @returns The last event received from the server
 */
export declare function useEventSource(url: string | URL, { event, init }?: EventSourceOptions): string | null;
export {};
