/**
 * @remix-run/dev v1.14.3
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

let parse = deps => Object.entries(deps || {}).map(([name, versionSpec]) => ({
  name,
  versionSpec
}));
let unparse = deps => {
  return Object.fromEntries(deps.map(({
    name,
    versionSpec
  }) => [name, versionSpec]));
};

exports.parse = parse;
exports.unparse = unparse;
