"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const BreadcrumbItem = (0, react_1.forwardRef)(({ children, className, href, icon: Icon, theme: customTheme = {}, ...props }, ref) => {
    const isLink = typeof href !== 'undefined';
    const Component = isLink ? 'a' : 'span';
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.breadcrumb.item, customTheme);
    return ((0, jsx_runtime_1.jsxs)("li", { className: (0, classnames_1.default)(theme.base, className), ...props, children: [(0, jsx_runtime_1.jsx)(hi_1.HiOutlineChevronRight, { "aria-hidden": true, className: theme.chevron, "data-testid": "flowbite-breadcrumb-separator" }), (0, jsx_runtime_1.jsxs)(Component, { ref: ref, className: theme.href[isLink ? 'on' : 'off'], "data-testid": "flowbite-breadcrumb-item", href: href, children: [Icon && (0, jsx_runtime_1.jsx)(Icon, { "aria-hidden": true, className: theme.icon }), children] })] }));
});
BreadcrumbItem.displayName = 'Breadcrumb.Item';
exports.default = BreadcrumbItem;
