"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Card = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const Card = ({ children, className, horizontal, href, imgAlt, imgSrc, theme: customTheme = {}, ...props }) => {
    const Component = typeof href === 'undefined' ? 'div' : 'a';
    const theirProps = props;
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.card, customTheme);
    return ((0, jsx_runtime_1.jsxs)(Component, { "data-testid": "flowbite-card", href: href, className: (0, classnames_1.default)(theme.root.base, theme.root.horizontal[horizontal ? 'on' : 'off'], href && theme.root.href, className), ...theirProps, children: [imgSrc && ((0, jsx_runtime_1.jsx)("img", { alt: imgAlt ?? '', src: imgSrc, className: (0, classnames_1.default)(theme.img.base, theme.img.horizontal[horizontal ? 'on' : 'off']) })), (0, jsx_runtime_1.jsx)("div", { className: theme.root.children, children: children })] }));
};
exports.Card = Card;
