"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dropdown = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = __importStar(require("react"));
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const uuid_1 = require("../../helpers/uuid");
const Button_1 = require("../Button");
const Floating_1 = require("../Floating");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const DropdownDivider_1 = require("./DropdownDivider");
const DropdownHeader_1 = require("./DropdownHeader");
const DropdownItem_1 = require("./DropdownItem");
const icons = {
    top: hi_1.HiOutlineChevronUp,
    right: hi_1.HiOutlineChevronRight,
    bottom: hi_1.HiOutlineChevronDown,
    left: hi_1.HiOutlineChevronLeft,
};
const DropdownComponent = ({ children, className, dismissOnClick = true, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.dropdown, customTheme);
    const theirProps = props;
    const { placement = props.inline ? 'bottom-start' : 'bottom', trigger = 'click', label, inline, floatingArrow = false, arrowIcon = true, ...buttonProps } = theirProps;
    const Icon = (0, react_1.useMemo)(() => {
        const [p] = placement.split('-');
        return icons[p] ?? hi_1.HiOutlineChevronDown;
    }, [placement]);
    const [closeRequestKey, setCloseRequestKey] = (0, react_1.useState)(undefined);
    // Extends DropdownItem's onClick to trigger a close request to the Floating component
    const attachCloseListener = (0, react_1.useCallback)(
    // @ts-ignore TODO: Rewrite Dropdown
    (node) => {
        if (!react_1.default.isValidElement(node))
            return node;
        if (node.type === DropdownItem_1.DropdownItem)
            return react_1.default.cloneElement(node, {
                // @ts-ignore TODO: Rewrite Dropdown
                onClick: () => {
                    node.props.onClick?.();
                    dismissOnClick && setCloseRequestKey((0, uuid_1.uuid)());
                },
            });
        if (node.props.children && typeof node.props.children === 'object') {
            return react_1.default.cloneElement(node, {
                // @ts-ignore TODO: Rewrite Dropdown
                children: react_1.Children.map(node.props.children, attachCloseListener),
            });
        }
        return node;
    }, [dismissOnClick]);
    const content = (0, react_1.useMemo)(() => (0, jsx_runtime_1.jsx)("ul", { className: theme.content, children: react_1.Children.map(children, attachCloseListener) }), [attachCloseListener, children, theme.content]);
    const TriggerWrapper = ({ children }) => inline ? (0, jsx_runtime_1.jsx)("button", { className: theme.inlineWrapper, children: children }) : (0, jsx_runtime_1.jsx)(Button_1.Button, { ...buttonProps, children: children });
    return ((0, jsx_runtime_1.jsx)(Floating_1.Floating, { content: content, style: "auto", animation: "duration-100", placement: placement, arrow: floatingArrow, trigger: trigger, theme: theme.floating, closeRequestKey: closeRequestKey, className: className, children: (0, jsx_runtime_1.jsxs)(TriggerWrapper, { children: [label, arrowIcon && (0, jsx_runtime_1.jsx)(Icon, { className: theme.arrowIcon })] }) }));
};
DropdownComponent.displayName = 'Dropdown';
DropdownItem_1.DropdownItem.displayName = 'Dropdown.Item';
DropdownHeader_1.DropdownHeader.displayName = 'Dropdown.Header';
DropdownDivider_1.DropdownDivider.displayName = 'Dropdown.Divider';
exports.Dropdown = Object.assign(DropdownComponent, {
    Item: DropdownItem_1.DropdownItem,
    Header: DropdownHeader_1.DropdownHeader,
    Divider: DropdownDivider_1.DropdownDivider,
});
