"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useThemeMode = exports.useTheme = exports.Flowbite = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const window_exists_1 = __importDefault(require("../../helpers/window-exists"));
const default_1 = __importDefault(require("../../theme/default"));
const ThemeContext_1 = require("./ThemeContext");
Object.defineProperty(exports, "useTheme", { enumerable: true, get: function () { return ThemeContext_1.useTheme; } });
Object.defineProperty(exports, "useThemeMode", { enumerable: true, get: function () { return ThemeContext_1.useThemeMode; } });
const Flowbite = ({ children, theme = {} }) => {
    const { theme: customTheme = {}, dark } = theme;
    const [mode, setMode, toggleMode] = (0, ThemeContext_1.useThemeMode)();
    const mergedTheme = (0, mergeDeep_1.mergeDeep)(default_1.default, customTheme);
    (0, react_1.useEffect)(() => {
        if (dark) {
            if (setMode != null) {
                setMode('dark');
            }
            if ((0, window_exists_1.default)()) {
                document.documentElement.classList.add('dark');
            }
        }
        else {
            if (setMode != null) {
                setMode('light');
            }
            if ((0, window_exists_1.default)()) {
                document.documentElement.classList.remove('dark');
            }
        }
    }, [dark, setMode]);
    const themeContextValue = (0, react_1.useMemo)(() => ({
        theme: mergedTheme,
        mode,
        toggleMode,
    }), [mode, toggleMode, mergedTheme]);
    return (0, jsx_runtime_1.jsx)(ThemeContext_1.ThemeContext.Provider, { value: themeContextValue, children: children });
};
exports.Flowbite = Flowbite;
