"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tooltip = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const Floating_1 = require("../Floating");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
/**
 * @see https://floating-ui.com/docs/react-dom-interactions
 */
const Tooltip = ({ animation = 'duration-300', arrow = true, children, className, content, placement = 'top', style = 'dark', theme: customTheme = {}, trigger = 'hover', ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.tooltip, customTheme);
    return ((0, jsx_runtime_1.jsx)(Floating_1.Floating, { animation: animation, arrow: arrow, content: content, placement: placement, style: style, theme: theme, trigger: trigger, className: className, ...props, children: children }));
};
exports.Tooltip = Tooltip;
