import { createElement, forwardRef } from 'react';
export const ButtonBase = forwardRef(({ children, as: Component = 'button', href, ...props }, ref) => {
    const BaseComponent = href ? 'a' : Component ?? 'button';
    const type = Component === 'button' ? 'button' : undefined;
    return createElement(BaseComponent, { ref, href, type, ...props }, children);
});
ButtonBase.displayName = 'Button';
