import type { ComponentProps, FC, PropsWithChildren, ReactNode } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteCarouselTheme {
    root: FlowbiteCarouselRootTheme;
    indicators: FlowbiteCarouselIndicatorsTheme;
    item: FlowbiteCarouselItemTheme;
    control: FlowbiteCarouselControlTheme;
    scrollContainer: FlowbiteCarouselScrollContainer;
}
export interface FlowbiteCarouselRootTheme {
    base: string;
    leftControl: string;
    rightControl: string;
}
export interface FlowbiteCarouselIndicatorsTheme {
    active: FlowbiteBoolean;
    base: string;
    wrapper: string;
}
export interface FlowbiteCarouselItemTheme {
    base: string;
    wrapper: string;
}
export interface FlowbiteCarouselControlTheme {
    base: string;
    icon: string;
}
export interface FlowbiteCarouselScrollContainer {
    base: string;
    snap: string;
}
export interface CarouselProps extends PropsWithChildren<ComponentProps<'div'>> {
    indicators?: boolean;
    leftControl?: ReactNode;
    rightControl?: ReactNode;
    slide?: boolean;
    slideInterval?: number;
    theme?: DeepPartial<FlowbiteCarouselTheme>;
}
export declare const Carousel: FC<CarouselProps>;
