import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { useContext } from 'react';
import { HiMoon, HiSun } from 'react-icons/hi';
import { mergeDeep } from '../../helpers/mergeDeep';
import { ThemeContext, useTheme } from '../Flowbite/ThemeContext';
export const DarkThemeToggle = ({ className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.darkThemeToggle, customTheme);
    const { mode, toggleMode } = useContext(ThemeContext);
    return (_jsx("button", { "aria-label": "Toggle dark mode", "data-testid": "dark-theme-toggle", onClick: toggleMode, type: "button", className: classNames(theme.root.base, className), ...props, children: mode === 'dark' ? (_jsx(HiSun, { "aria-label": "Currently dark mode", className: theme.root.icon })) : (_jsx(HiMoon, { "aria-label": "Currently light mode", className: theme.root.icon })) }));
};
