import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const DropdownItem = ({ children, className, icon: Icon, onClick, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.dropdown.floating.item, customTheme);
    return (_jsxs("li", { className: classNames(theme.base, className), onClick: onClick, ...props, children: [Icon && _jsx(Icon, { className: theme.icon }), children] }));
};
