import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterBrand = ({ alt, className, children, href, name, src, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.brand, customTheme);
    return (_jsx("div", { children: href ? (_jsxs("a", { "data-testid": "flowbite-footer-brand", href: href, className: classNames(theme.base, className), ...props, children: [_jsx("img", { alt: alt, src: src, className: theme.img }), _jsx("span", { "data-testid": "flowbite-footer-brand-span", className: theme.span, children: name }), children] })) : (_jsx("img", { alt: alt, "data-testid": "flowbite-footer-brand", src: src, className: classNames(theme.img, className), ...props })) }));
};
