import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterIcon = ({ ariaLabel, className, href, icon: Icon, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.icon, customTheme);
    return (_jsx("div", { children: href ? (_jsx("a", { "aria-label": ariaLabel, "data-testid": "flowbite-footer-icon", href: href, className: classNames(theme.base, className), ...props, children: _jsx(Icon, { className: theme.size }) })) : (_jsx(Icon, { "data-testid": "flowbite-footer-icon", className: theme.size, ...props })) }));
};
