import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteHelperTextTheme {
    root: FlowbiteHelperTextRootTheme;
}
export interface FlowbiteHelperTextRootTheme {
    base: string;
    colors: HelperColors;
}
export interface HelperColors extends Pick<FlowbiteColors, 'gray' | 'info' | 'failure' | 'warning' | 'success'> {
    [key: string]: string;
}
export interface HelperTextProps extends PropsWithChildren<Omit<ComponentProps<'p'>, 'color'>> {
    color?: keyof HelperColors;
    theme?: DeepPartial<FlowbiteHelperTextTheme>;
    value?: string;
}
export declare const HelperText: FC<HelperTextProps>;
