import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean, FlowbitePositions, FlowbiteSizes } from '../Flowbite/FlowbiteTheme';
import type { FlowbiteModalBodyTheme } from './ModalBody';
import type { FlowbiteModalFooterTheme } from './ModalFooter';
import type { FlowbiteModalHeaderTheme } from './ModalHeader';
export interface FlowbiteModalTheme {
    root: FlowbiteModalRootTheme;
    content: FlowbiteModalContentTheme;
    body: FlowbiteModalBodyTheme;
    header: FlowbiteModalHeaderTheme;
    footer: FlowbiteModalFooterTheme;
}
export interface FlowbiteModalRootTheme {
    base: string;
    show: FlowbiteBoolean;
    sizes: ModalSizes;
    positions: ModalPositions;
}
export interface FlowbiteModalContentTheme {
    base: string;
    inner: string;
}
export interface ModalPositions extends FlowbitePositions {
    [key: string]: string;
}
export interface ModalSizes extends Omit<FlowbiteSizes, 'xs'> {
    [key: string]: string;
}
export interface ModalProps extends PropsWithChildren<ComponentProps<'div'>> {
    onClose?: () => void;
    position?: keyof ModalPositions;
    popup?: boolean;
    root?: HTMLElement;
    show?: boolean;
    size?: keyof ModalSizes;
    dismissible?: boolean;
    theme?: DeepPartial<FlowbiteModalTheme>;
}
export declare const Modal: FC<ModalProps> & {
    Header: FC<import("./ModalHeader").ModalHeaderProps>;
    Body: FC<import("./ModalBody").ModalBodyProps>;
    Footer: FC<import("./ModalFooter").ModalFooterProps>;
};
