import type { ComponentProps } from 'react';
import type { DeepPartial } from '..';
import type { TextInputSizes } from '../TextInput';
export interface FlowbiteRangeSliderTheme {
    root: FlowbiteRangeSliderRootTheme;
    field: FlowbiteRangeSliderFieldTheme;
}
export interface FlowbiteRangeSliderRootTheme {
    base: string;
}
export interface FlowbiteRangeSliderFieldTheme {
    base: string;
    input: {
        base: string;
        sizes: TextInputSizes;
    };
}
export interface RangeSliderProps extends Omit<ComponentProps<'input'>, 'ref' | 'type'> {
    sizing?: keyof TextInputSizes;
    theme?: DeepPartial<FlowbiteRangeSliderTheme>;
}
export declare const RangeSlider: import("react").ForwardRefExoticComponent<RangeSliderProps & import("react").RefAttributes<HTMLInputElement>>;
