import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteSidebarCTATheme {
    base: string;
    color: FlowbiteSidebarCTAColors;
}
export interface SidebarCTAProps extends PropsWithChildren, Omit<ComponentProps<'div'>, 'color'> {
    color?: keyof FlowbiteSidebarCTAColors;
    theme?: DeepPartial<FlowbiteSidebarCTATheme>;
}
export interface FlowbiteSidebarCTAColors extends Pick<FlowbiteColors, 'blue' | 'dark' | 'failure' | 'gray' | 'green' | 'light' | 'purple' | 'red' | 'success' | 'warning' | 'yellow'> {
    [key: string]: string;
}
declare const SidebarCTA: FC<SidebarCTAProps>;
export default SidebarCTA;
