import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite';
import { useTimelineContext } from './TimelineContext';
export const TimelineContent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.timeline.item.content, customTheme);
    const { horizontal } = useTimelineContext();
    return (_jsx("div", { "data-testid": "timeline-content", className: classNames(horizontal && theme.root.base, className), ...props, children: children }));
};
