import React from 'react';
import { type InputMask, type InputMaskElement, type FactoryOpts, type AllFactoryStaticOpts } from 'imask';
export type Falsy = false | 0 | "" | null | undefined;
export type ReactMaskOpts<Opts extends FactoryOpts = FactoryOpts> = Opts & {
    unmask?: 'typed' | boolean;
};
export type UnmaskValue<Opts extends ReactMaskOpts> = Opts['unmask'] extends 'typed' ? InputMask<Opts>['typedValue'] : Opts['unmask'] extends Falsy ? InputMask<Opts>['value'] : InputMask<Opts>['unmaskedValue'];
export type ReactMaskProps<MaskElement extends InputMaskElement, Opts extends ReactMaskOpts = ReactMaskOpts> = {
    onAccept?: (value: UnmaskValue<Opts>, maskRef: InputMask<Opts>, e?: InputEvent) => void;
    onComplete?: (value: UnmaskValue<Opts>, maskRef: InputMask<Opts>, e?: InputEvent) => void;
    unmask?: Opts['unmask'];
    value?: UnmaskValue<Opts>;
    inputRef?: React.Ref<MaskElement>;
    ref?: React.Ref<React.ComponentType<IMaskInputProps<MaskElement>>>;
};
declare const MASK_PROPS: {
    [key in keyof (AllFactoryStaticOpts & ReactMaskProps<InputMaskElement, AllFactoryStaticOpts>)]: any;
};
declare const NON_MASK_OPTIONS_PROPS_NAMES: readonly ["value", "unmask", "onAccept", "onComplete", "inputRef"];
export type ReactElementProps<MaskElement extends InputMaskElement> = Omit<Omit<React.HTMLProps<MaskElement>, keyof typeof MASK_PROPS>, typeof NON_MASK_OPTIONS_PROPS_NAMES[number]>;
export type ReactMixinComponent<MaskElement extends InputMaskElement> = React.ComponentType<ReactElementProps<MaskElement> & {
    inputRef: React.Ref<MaskElement>;
}>;
export type MaskPropsKeys = Exclude<keyof typeof MASK_PROPS, typeof NON_MASK_OPTIONS_PROPS_NAMES[number]>;
export type MaskOpts<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement> = IMaskInputProps<MaskElement>> = Extract<Props, FactoryOpts>;
export type IMaskMixinProps<MaskElement extends InputMaskElement, Props extends (ReactMaskOpts & ReactMaskProps<MaskElement>) = ReactMaskOpts & ReactMaskProps<MaskElement>> = Omit<ReactMaskProps<MaskElement, Props>, 'ref'> & MaskOpts<MaskElement, Props>;
export type IMaskInputProps<MaskElement extends InputMaskElement, Props extends IMaskMixinProps<MaskElement> = IMaskMixinProps<MaskElement>> = ReactElementProps<MaskElement> & IMaskMixinProps<MaskElement, Props>;
export default function IMaskMixin<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement>>(ComposedComponent: ReactMixinComponent<MaskElement>): React.ForwardRefExoticComponent<React.PropsWithoutRef<Props> & React.RefAttributes<React.ComponentType<Props>>>;
export {};
//# sourceMappingURL=mixin.d.ts.map