import { DefaultScrollOptions, BasicScrollOptions, LoopedFunction, Scroll } from '../types';
import { RefObject } from 'react';
import { AbstractArtificialScroll } from './AbstractArtificialScroll';
interface DirectionSpeed {
    local: number;
    global: number;
    overflow: number;
}
interface PartitionedScroll {
    left: DirectionSpeed;
    top: DirectionSpeed;
}
interface OverflowState {
    left: number;
    top: number;
    prevent: boolean;
}
interface OriginalStyles {
    transform: string[];
    transition: string[];
    pointerEvents: string[];
}
interface Inertia {
    left: number;
    top: number;
}
declare type ScrollMode = 'local' | 'global' | null;
export declare class DefaultArtificialScroll implements AbstractArtificialScroll {
    reference: RefObject<HTMLElement | null>;
    options: RefObject<DefaultScrollOptions & BasicScrollOptions>;
    overflow: OverflowState;
    originalStyles: OriginalStyles;
    inertiaSpeed: Inertia;
    mode: ScrollMode;
    active: boolean;
    loopedInertia: LoopedFunction;
    debouncedClearStyles: () => void;
    constructor(reference: RefObject<HTMLElement | null>, options: RefObject<DefaultScrollOptions & BasicScrollOptions>);
    getOptions(): {
        inertia: boolean;
        rubberBand: boolean;
        overscroll?: boolean | undefined;
        buttons?: number[] | undefined;
        activationDistance?: number | undefined;
        ignoreElements?: string | undefined;
    };
    start(scroll: Scroll): void;
    scroll(scroll: Scroll): void;
    end(scroll?: Scroll, callback?: () => void): void;
    cancel(): void;
    protected getScrollMode: (scroll?: Scroll | undefined) => "local" | "global";
    protected resetOverflow(): void;
    protected preventEvent(e: Event): void;
    protected applyScroll({ left, top }: PartitionedScroll): void;
    protected clearStyles: () => void;
    protected inertia: (diff: number, complete?: (() => void) | undefined) => void;
    protected calculateScroll(scroll: Scroll): PartitionedScroll;
}
export declare function defaultMouseScrollImplementation(reference: RefObject<HTMLElement | null>, options: RefObject<DefaultScrollOptions & BasicScrollOptions>): DefaultArtificialScroll;
export {};
