export declare type Locales = string[] | undefined;
/**
 * Get the client's locales from the Accept-Language header.
 * If the header is not defined returns null.
 * If the header is defined return an array of locales, sorted by the quality
 * value.
 *
 * @example
 * export async function loader({ request }: LoaderArgs) {
 *   let locales = getClientLocales(request)
 *   let date = new Date().toLocaleDateString(locales, {
 *     "day": "numeric",
 *   });
 *   return json({ date })
 * }
 */
export declare function getClientLocales(headers: Headers): Locales;
export declare function getClientLocales(request: Request): Locales;
