"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamicLinks = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_2 = require("@remix-run/react");
function DynamicLinks() {
    let location = (0, react_2.useLocation)();
    let links = (0, react_2.useMatches)().flatMap((match, index, matches) => {
        var _a;
        let fn = (_a = match.handle) === null || _a === void 0 ? void 0 : _a.dynamicLinks;
        if (typeof fn !== "function")
            return [];
        let result = fn({
            id: match.id,
            data: match.data,
            params: match.params,
            location,
            parentsData: matches.slice(0, index).map((match) => match.data),
        });
        if (Array.isArray(result))
            return result;
        return [];
    });
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: links.map((link) => ((0, react_1.createElement)("link", { ...link, key: link.integrity || JSON.stringify(link) }))) }));
}
exports.DynamicLinks = DynamicLinks;
