"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerOnly = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const use_hydrated_1 = require("./use-hydrated");
/**
 * Render the children only before the JS has loaded client-side. Use an
 * optional fallback component for once the JS has loaded.
 *
 * Example: Render a hidden input to identify if the user has JS.
 * ```tsx
 * return (
 *   <ServerOnly fallback={<FakeChart />}>
 *     {() => <Chart />}
 *   </ServerOnly>
 * );
 * ```
 */
function ServerOnly({ children, fallback = null }) {
    return (0, use_hydrated_1.useHydrated)() ? (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: fallback }) : (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: children() });
}
exports.ServerOnly = ServerOnly;
