"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPrefetch = void 0;
const get_headers_1 = require("./get-headers");
function isPrefetch(requestOrHeaders) {
    let headers = (0, get_headers_1.getHeaders)(requestOrHeaders);
    let purpose = headers.get("Purpose") ||
        headers.get("X-Purpose") ||
        headers.get("Sec-Purpose") ||
        headers.get("Sec-Fetch-Purpose") ||
        headers.get("Moz-Purpose") ||
        headers.get("X-Moz");
    return (purpose === null || purpose === void 0 ? void 0 : purpose.toLowerCase()) === "prefetch";
}
exports.isPrefetch = isPrefetch;
