import { Carousel } from "flowbite-react"
import { ClientOnly } from "remix-utils"
import { Link } from "@remix-run/react"
import Next from "../../public/assets/img/next-btn.webp"
import Prev from "../../public/assets/img/back-btn.webp"
import { numberWithCommas } from "~/helpers/functions"
import { useEffect, useState } from "react"

const CarouselMasVendidos = ({carousel, baseUrl}) => {
    const CarouselCustomTheme =  {
        root: {
            leftControl: "absolute top-0 -left-16 flex h-full items-center justify-center px-4 focus:outline-none",
            rightControl: "absolute top-0 -right-16 flex h-full items-center justify-center px-4 focus:outline-none"
        }
	}

    const [ items, setItems ] = useState({})

    useEffect( () => {
        const masvendidos = carousel.filter( item => item.b_mas_vendido === 1 )
        setItems(masvendidos)
    }, [])
    
    return (
        <ClientOnly fallback={''}>
            { () => (
                items?.length > 0 ?
                    <>
                        {/*0 to 640*/}
                        <Carousel
                            slideInterval={5000}
                            className="sm:hidden md:hidden lg:hidden xl:hidden"
                            indicators={false}
                            leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-10 lg:-left-14 w-20" /></div>}
                            rightControl={<div><img src={Next} alt="Siguiente" className="relative left-10 lg:left-14 w-20" /></div>}
                        >
                            {
                                items?.length ? 
                                    items?.map( (item, idx) => (
                                        <div key={idx} className="w-1/6 bg-white m-1 flex flex-col justify-between items-center px-0 py-5">
                                            {
                                                (item.i_descuento === 0 ) ? 
                                                    <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                :
                                                    <div className="relative">
                                                        <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                        <div className="absolute top-5 text-center left-8">
                                                            <span className="bg-eRed text-white uppercase font-MontserratRegular text-sm rounded-md py-1 px-2">menos {item.i_descuento}%</span>
                                                        </div>
                                                    </div>
                                            }

                                            <p className="text-eBlack text-center mb-2 px-2">{item.vc_modelo}</p>
                                            {
                                                item.i_descuento === 0 ?
                                                    <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${item.f_precio}</p>
                                                : 
                                                    <>
                                                        <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xs mb-2 px-2 line-through">${item.f_precio}</p>
                                                        <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${ numberWithCommas((item.f_precio.replace(",","") / (1+(item.i_descuento/100))).toFixed(2)) }</p>
                                                    </>
                                            }
                                            <div>
                                                {
                                                    (item.i_descuento === 0 ) ? 
                                                        <Link to={`/productos/`+item.vc_url} className="bg-eYellow py-2 px-5 text-eBlack !rounded-full">Ver&nbsp;Detalles</Link>
                                                    :    
                                                        <Link to={`/productos/`+item.vc_url} className="bg-eRed py-2 px-5 text-white !rounded-full">Ver&nbsp;Promoción</Link>
                                                }
                                            </div>
                                        </div>
                                    ))
                                : "Sin elementos"
                            }
                        </Carousel>

                        {/*640 to 768*/}
                        <Carousel
                            slideInterval={5000}
                            className="hidden sm:block md:hidden lg:hidden xl:hidden"
                            indicators={false}
                            leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-14 w-20" /></div>}
                            rightControl={<div><img src={Next} alt="Siguiente" className="relative left-14 w-20" /></div>}
                        >
                            {
                                (
                                    () => {
                                        const options = [];
                                        for (let i = 0; i < Math.ceil(items.length/2); i++) {
                                            options.push(<div key={i} className="flex">
                                                {
                                                    items.map( (item, idx) => (
                                                        ( idx >= 2*i && idx < 2*(i+1) ) ?
                                                            <div key={idx} className="w-1/2 bg-white m-1 flex flex-col justify-between items-center px-0 py-5">
                                                                {
                                                                    (item.i_descuento === 0 ) ? 
                                                                        <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                    :
                                                                        <div className="relative">
                                                                            <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                            <div className="absolute top-5 text-center left-8">
                                                                                <span className="bg-eRed text-white uppercase font-MontserratRegular text-sm rounded-md py-1 px-2">menos {item.i_descuento}%</span>
                                                                            </div>
                                                                        </div>
                                                                }

                                                                <p className="text-eBlack text-center mb-2 px-2">{item.vc_modelo}</p>
                                                                {
                                                                    item.i_descuento === 0 ?
                                                                        <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${item.f_precio}</p>
                                                                    : 
                                                                        <>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xs mb-2 px-2 line-through">${item.f_precio}</p>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${ numberWithCommas((item.f_precio.replace(",","") / (1+(item.i_descuento/100))).toFixed(2)) }</p>
                                                                        </>
                                                                }
                                                                <div>
                                                                    {
                                                                        (item.i_descuento === 0 ) ? 
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eYellow py-2 px-5 text-eBlack !rounded-full">Ver Detalles</Link>
                                                                        :    
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eRed py-2 px-5 text-white !rounded-full">Ver Promoción</Link>
                                                                    }
                                                                </div>
                                                            </div>
                                                        : ""
                                                    ))
                                                }
                                            </div>)
                                        }
                                        return options;
                                    }
                                )()
                            }
                        </Carousel>

                        {/*768 to 1024*/}
                        <Carousel
                            slideInterval={5000}
                            className="hidden sm:hidden md:block lg:hidden xl:hidden"
                            indicators={false}
                            theme={CarouselCustomTheme}
                            leftControl={<div><img src={Prev} alt="Anterior" className="relative w-20" /></div>}
                            rightControl={<div><img src={Next} alt="Siguiente" className="relative w-20" /></div>}
                        >
                            {
                                (
                                    () => {
                                        const options = [];
                                        for (let i = 0; i < Math.ceil(items.length/3); i++) {
                                            options.push(<div key={i} className="flex">
                                                {
                                                    items.map( (item, idx) => (
                                                        ( idx >= 3*i && idx < 3*(i+1) ) ?
                                                            <div key={idx} className="w-1/3 bg-white m-1 flex flex-col justify-between items-center px-0 py-5">
                                                                {
                                                                    (item.i_descuento === 0 ) ? 
                                                                        <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                    :
                                                                        <div className="relative">
                                                                            <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                            <div className="absolute top-5 text-center left-8">
                                                                                <span className="bg-eRed text-white uppercase font-MontserratRegular text-sm rounded-md py-1 px-2">menos {item.i_descuento}%</span>
                                                                            </div>
                                                                        </div>
                                                                }

                                                                <p className="text-eBlack text-center mb-2 px-2">{item.vc_modelo}</p>
                                                                {
                                                                    item.i_descuento === 0 ?
                                                                        <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${item.f_precio}</p>
                                                                    : 
                                                                        <>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xs mb-2 px-2 line-through">${item.f_precio}</p>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${ numberWithCommas((item.f_precio.replace(",","") / (1+(item.i_descuento/100))).toFixed(2)) }</p>
                                                                        </>
                                                                }
                                                                <div>
                                                                    {
                                                                        (item.i_descuento === 0 ) ? 
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eYellow py-2 px-5 text-eBlack !rounded-full">Ver Detalles</Link>
                                                                        :    
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eRed py-2 px-5 text-white !rounded-full">Ver Promoción</Link>
                                                                    }
                                                                </div>
                                                            </div>
                                                        : ""
                                                    ))
                                                }
                                            </div>)
                                        }
                                        return options;
                                    }
                                )()
                            }
                        </Carousel>

                        {/*1024 to 1280*/}
                        <Carousel
                            slideInterval={5000}
                            className="hidden sm:hidden md:hidden lg:block "
                            indicators={false}
                            theme={CarouselCustomTheme}
                            leftControl={<div><img src={Prev} alt="Anterior" className="relative w-20" /></div>}
                            rightControl={<div><img src={Next} alt="Siguiente" className="relative w-20" /></div>}
                        >
                            {
                                (
                                    () => {
                                        const options = [];
                                        for (let i = 0; i < Math.ceil(items.length/5); i++) {
                                            options.push(<div key={i} className="flex">
                                                {
                                                    items.map( (item, idx) => (
                                                        ( idx >= 5*i && idx < 5*(i+1) ) ?
                                                            <div key={idx} className="w-1/5 bg-white m-1 flex flex-col justify-between items-center px-0 py-5">
                                                                {
                                                                    (item.i_descuento === 0 ) ? 
                                                                        <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                    :
                                                                        <div className="relative">
                                                                            <img src={baseUrl+item.vc_imagen} alt="Puerta de seguridad" className="mb-2" />
                                                                            <div className="absolute top-5 text-center -left-4">
                                                                                <span className="bg-eRed text-white uppercase font-MontserratRegular text-sm rounded-md py-1 px-2">menos {item.i_descuento}%</span>
                                                                            </div>
                                                                        </div>
                                                                }

                                                                <p className="text-eBlack text-center mb-2 px-2">{item.vc_modelo}</p>
                                                                {
                                                                    item.i_descuento === 0 ?
                                                                        <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${item.f_precio}</p>
                                                                    : 
                                                                        <>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xs mb-2 px-2 line-through">${item.f_precio}</p>
                                                                            <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${ numberWithCommas((item.f_precio.replace(",","") / (1+(item.i_descuento/100))).toFixed(2)) }</p>
                                                                        </>
                                                                }
                                                                <div>
                                                                    {
                                                                        (item.i_descuento === 0 ) ? 
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eYellow py-2 px-5 text-eBlack !rounded-full">Ver Detalles</Link>
                                                                        :    
                                                                            <Link to={`/productos/`+item.vc_url} className="bg-eRed py-2 px-5 text-white !rounded-full">Ver Promoción</Link>
                                                                    }
                                                                </div>
                                                            </div>
                                                        : ""
                                                    ))
                                                }
                                            </div>)
                                        }
                                        return options;
                                    }
                                )()
                            }
                        </Carousel>
                    </>
                : "Sin Datos"
            ) }
        </ClientOnly>    
    )
}

export default CarouselMasVendidos
