import { Link } from "@remix-run/react"
const ListadoDeProductos = ({productos, currentPage}) => {
    //const { f_precio, i_descuento, vc_imagen, vc_modelo, vc_puerta } = puertas

    const numberWithCommas = (x) => {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }    

    return (
        productos.map( (producto, idx) => (
            (idx >= currentPage*15 && idx < 15*(currentPage+1) ) ? 
                <div key={producto.id}>
                    <div className="w-full bg-white flex flex-col justify-between items-center mb-2 px-1 py-5">
                        {
                            producto.i_descuento === 0 ?
                                <img src={`https://testing1.eversafe.com.mx${producto.vc_imagen}`} alt={producto.vc_puerta === undefined ? producto.vc_producto : producto.vc_puerta} />
                            :
                                <div className="relative">
                                    <img src={`https://testing1.eversafe.com.mx${producto.vc_imagen}`} alt={producto.vc_puerta === undefined ? producto.vc_producto : producto.vc_puerta} />
                                    <div className="absolute top-5 text-center -left-4">
                                        <span className="bg-eRed text-white uppercase font-MontserratRegular text-sm rounded-md py-1 px-2">menos {producto.i_descuento}%</span>
                                    </div>
                                </div>
                        }
                        <p className="text-eBlack text-sm text-center uppercase mb-2 px-2">
                            {producto.vc_puerta === undefined ? producto.vc_producto : producto.vc_modelo}
                        </p>
                        {
                            producto.i_descuento === 0 ?
                                <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${producto.f_precio}</p>
                            : 
                                <>
                                    <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xs mb-2 px-2 line-through">${producto.f_precio}</p>
                                    <p className="w-full text-eBlack text-center font-MontserratSemiBold text-xl mb-2 px-2">${ numberWithCommas((producto.f_precio.replace(",","") - (producto.f_precio.replace(",","")*(producto.i_descuento/100))).toFixed(2))}</p>
                                </>
                        }
                        <div>
                            <Link to={`/productos/${producto.vc_url}`} className={`${producto.i_descuento === 0 ? "bg-eYellow" : "bg-eRed"} text-eBlack !rounded-full py-2 px-5`}>Ver Detalles</Link>
                        </div>
                    </div>
                </div>
            : ""
        ))
    )
}

export default ListadoDeProductos