import { useEffect, useState } from "react"

const ListaOpcionesDiseno = ({
    disenoOptionsShow, 
    Empty,
    dataOpcionesDiseno, 
    configuracion, 
    setDisenoBatiente, 
    setDisenoPivote, 
    setDisenoFijoAbatible, 
    setDisenoDoble, baseUrl, puertaMedidaCarrito, setPuertaMedidaCarrito
}) => {
    const [ seleccion, setSeleccion ] = useState("")

    useEffect(() => {
        if (typeof dataOpcionesDiseno.length === 'undefined') {
            setSeleccion("")
        }
    }, [dataOpcionesDiseno])
    
    const loadOpcion = (batiente, pivote, fijoabatible, doble, id, precio_batiente, precio_pivote, precio_fijoabatible, precio_doble, elemento_nombre, preview) => {
        if( configuracion === "batiente" ) {
            setDisenoBatiente(baseUrl+batiente)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textDiseno: id, textDisenoPrecio: precio_batiente, textDisenoImagen: preview, nombreDiseno: elemento_nombre })
        } else if( configuracion === "pivote" ) {
            setDisenoPivote(baseUrl+pivote)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textDiseno: id, textDisenoPrecio: precio_pivote, textDisenoImagen: preview, nombreDiseno: elemento_nombre })
        } else if( configuracion === "fijoabatible" ) {
            setDisenoFijoAbatible(baseUrl+fijoabatible)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textDiseno: id, textDisenoPrecio: precio_fijoabatible, textDisenoImagen: preview, nombreDiseno: elemento_nombre })
        } else if( configuracion === "doble" ) {
            setDisenoDoble(baseUrl+doble)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textDiseno: id, textDisenoPrecio: precio_doble, textDisenoImagen: preview, nombreDiseno: elemento_nombre })
        }
    }

    const remove = () => {
        setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textDiseno: "", textDisenoPrecio: "", textDisenoImagen: "", nombreDiseno: "" })

        setSeleccion("")
        setDisenoBatiente(Empty)
        setDisenoPivote(Empty)
        setDisenoFijoAbatible(Empty)
        setDisenoDoble(Empty)
    }

    return (
        <div className={`mt-5 grid grid-cols-1 gap-1 ${disenoOptionsShow}`}>
            {
                dataOpcionesDiseno?.length ? (
                    dataOpcionesDiseno.map( opts => (
                        <div key={opts.id} className={`bg-white w-32 flex flex-col justify-center items-center px-2 py-5 ${opts.id === seleccion ? 'border-2 border-solid border-eYellow' : ''}`}>
                            <img src={baseUrl+opts.vc_img_preview} alt="Diseño" className="w-max-full h-28 mb-3" />
                            <p className="w-full text-center text-eGray font-MontserratRegular text-sm">{opts.vc_nombre}</p>
                            {
                                ( configuracion === "batiente") ? 
                                    <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_batiente}</p> 
                                : 
                                    ( configuracion === "pivote") ? 
                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_pivote}</p> 
                                    : 
                                        ( configuracion === "fijoabatible") ? 
                                            <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_batiente_fijo}</p> 
                                                : 
                                                    ( configuracion === "doble") ? 
                                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_doble}</p> 
                                                            : 
                                                                "No hay opciones"
                            }
                            {
                                opts.id === seleccion ? <button onClick={() => remove()} className="mt-5 bg-eLightGray text-eGray text-sm px-4 py-1 rounded-full">Remover</button>
                                : <button onClick={() => loadOpcion(opts.vc_img_batiente, opts.vc_img_pivote, opts.vc_img_batiente_fijo, opts.vc_img_doble, opts.id, opts.f_precio_batiente, opts.f_precio_pivote, opts.f_precio_batiente_fijo, opts.f_precio_doble, opts.vc_nombre, opts.vc_img_preview)} className="mt-5 bg-eYellow text-eGray text-sm px-4 py-1 rounded-full">Agregar</button>
                            }
                        </div>
                    ))
                ) : "No hay opciones de diseño"
            }
        </div>
    )
}

export default ListaOpcionesDiseno