import { Link } from "@remix-run/react"
import PersonalizaBanner from "../../public/assets/img/img-banner.webp"
import Tools from "../../public/assets/img/tool-icon.webp"

const PersonalizaTuPuerta = () => {
    return (  
        <section>
            <div className="lg:flex">
                <div className="lg:w-1/2">
                    <img src={PersonalizaBanner} alt="Personaliza tu puerta" />
                </div>
                <div className="lg:w-1/2 bg-eYellow p-5 lg:p-10 lg:flex flex-col justify-center items-center">
                    <div className="flex justify-center items-start">
                        <img className="w-6 mt-2 mr-3" src={Tools} alt="Personaliza tu puerta a la medida" />
                        <p className="text-2xl xl:text-3xl text-eBlack font-MontserratSemiBold uppercase">personaliza tu<br />puerta a la medida</p>
                    </div>
                    <div className="sm:flex mt-5">
                        <div className="sm:w-1/2 p-2">
                            <ul>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Puertas a la medida</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Estructura de seguridad</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Diseño personalizable</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Acabados Premium</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Envíos a domicilio</li>
                            </ul>
                        </div>
                        <div className="sm:w-1/2 p-2">
                            <ul>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Servicio de instalación</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Materiales de alta calidad</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Cerradura de seguridad</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Servicio Postventa</li>
                                <li className="bg-checkPattern bg-no-repeat pl-10 text-eBlack text-lg lg:text-xs xl:text-base font-MontserratMedium uppercase">Innovación en Fabricación</li>
                            </ul>
                        </div>
                    </div>
                    <div className="flex justify-center items-center mt-5">
                        <Link to="/puertas-a-medida" className="bg-white hover:bg-white text-eBlack text-lg font-MontserratRegular !rounded-full py-3 px-8">¡Créala ahora!</Link>
                    </div>
                </div>
            </div>
        </section>
    )
}

export default PersonalizaTuPuerta
