import { Link, useLoaderData } from "@remix-run/react"
import Contacto from "~/components/contacto"
import Banner from "../../public/assets/img/cintillo-img.webp"
import Sucursal1 from "../../public/assets/img/sucursal01.webp"
import Sucursal2 from "../../public/assets/img/sucursal02.webp"
import Sucursal3 from "../../public/assets/img/sucursal03.webp"
import Sucursal4 from "../../public/assets/img/sucursal04.webp"

export async function loader() {
    loaderData = {
		baseUrlApi: process.env.API_URL
    }
    return loaderData
}

const ContactoInt = () => {
    const loadedData = useLoaderData()
    const { baseUrlApi } = loadedData
    return (
        <>
            <section>
                <Link to="/productos"><img src={Banner} alt="¿Quienes somos?" /></Link>
            </section>

            <Contacto 
                baseUrlApi={baseUrlApi}
            />

            <section id="sucursales" className="bg-eLightGray py-20">
                <h2 className="p-2 text-center uppercase text-eBlue font-MontserratBold text-2xl lg:text-3xl">estamos más cerca de ti,<br /><span className="text-eGray">conoce nuestras sucursales.</span></h2>

                <div className="lg:flex w-10/12 mx-auto mt-10 lg:mt-10">
                    <div className="lg:w-1/4 my-5">
                        <div className="bg-white mx-2 px-3 py-8 rounded-sm">
                            <h3 className="text-center text-eBlue font-MontserratSemiBold uppercase mb-5">Sucursal Valle</h3>
                            <img src={Sucursal1} alt="Sucursal" className="mb-5" />
                            <p className="text-center font-MontserratRegular text-xs mb-5">Av. Jose Casconcelos 300-C, Del Valle, 66240 San Pedro Garza García, N.L.</p>
                            <div className="flex justify-center items-center">
                                <Link to="https://goo.gl/maps/hxxj4CAACUmknRza7" target="_blank" className="bg-eYellow text-eGray rounded-full px-10 py-2"> Ver en mapa </Link>
                            </div>
                        </div>
                    </div>
                    <div className="lg:w-1/4 my-5">
                        <div className="bg-white mx-2 px-3 py-8 rounded-sm">
                            <h3 className="text-center text-eBlue font-MontserratSemiBold uppercase mb-5">Sucursal Cumbres</h3>
                            <img src={Sucursal2} alt="Sucursal" className="mb-5" />
                            <p className="text-center font-MontserratRegular text-xs mb-5">Av. Paseo de los Leones 2282, Cumbres 2o. Sector Secc. C, 64610, Monterrey, N.L.</p>
                            <div className="flex justify-center items-center">
                                <Link to="https://goo.gl/maps/ZuLqtLm2juuvNyua6" target="_blank" className="bg-eYellow text-eGray rounded-full px-10 py-2"> Ver en mapa </Link>
                            </div>
                        </div>
                    </div>
                    <div className="lg:w-1/4 my-5">
                        <div className="bg-white mx-2 px-3 py-8 rounded-sm">
                            <h3 className="text-center text-eBlue font-MontserratSemiBold uppercase mb-5">Sucursal Carretera</h3>
                            <img src={Sucursal3} alt="Sucursal" className="mb-5" />
                            <p className="text-center font-MontserratRegular text-xs mb-5">Carretera Monterrey-Santiago 5726, Mederos, 64950, Monterrey, N.L.</p>
                            <div className="flex justify-center items-center">
                                <Link to="https://goo.gl/maps/cH3cz4gvgMg9n4Ys6" target="_blank" className="bg-eYellow text-eGray rounded-full px-10 py-2"> Ver en mapa </Link>
                            </div>
                        </div>
                    </div>
                    <div className="lg:w-1/4 my-5">
                        <div className="bg-white mx-2 px-3 py-8 rounded-sm">
                            <h3 className="text-center text-eBlue font-MontserratSemiBold uppercase mb-5">Sucursal Contry</h3>
                            <img src={Sucursal4} alt="Sucursal" className="mb-5" />
                            <p className="text-center font-MontserratRegular text-xs mb-5">Manuel Acuña 2347, Contry La Silla 8o. Sector, 67173, N.L.</p>
                            <div className="flex justify-center items-center">
                                <Link to="https://goo.gl/maps/aJoERStBhqh6JaN7A" target="_blank" className="bg-eYellow text-eGray rounded-full px-10 py-2"> Ver en mapa </Link>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </>
    )
}

export default ContactoInt
