"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useThemeMode = exports.useTheme = exports.ThemeProvider = exports.ThemeContext = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const window_exists_1 = __importDefault(require("../../helpers/window-exists"));
const default_1 = __importDefault(require("../../theme/default"));
exports.ThemeContext = (0, react_1.createContext)({
    theme: default_1.default,
});
const ThemeProvider = ({ children, value }) => {
    return (0, jsx_runtime_1.jsx)(exports.ThemeContext.Provider, { value: value, children: children });
};
exports.ThemeProvider = ThemeProvider;
function useTheme() {
    return (0, react_1.useContext)(exports.ThemeContext);
}
exports.useTheme = useTheme;
const useThemeMode = () => {
    const userPreferenceIsDark = () => (0, window_exists_1.default)() && window.matchMedia?.('(prefers-color-scheme: dark)').matches;
    const getPrefersColorScheme = () => (userPreferenceIsDark() ? 'dark' : 'light');
    const onToggleMode = () => {
        const newMode = mode === 'dark' ? 'light' : 'dark';
        setMode(newMode);
        setModeState(newMode);
    };
    const { mode: contextMode, toggleMode = onToggleMode } = (0, react_1.useContext)(exports.ThemeContext);
    const [mode, setModeState] = (0, react_1.useState)(contextMode ? contextMode : getPrefersColorScheme());
    const setMode = (0, react_1.useCallback)((mode) => {
        if (!(0, window_exists_1.default)()) {
            return;
        }
        if (mode === 'dark') {
            document.documentElement.classList.add('dark');
            return;
        }
        document.documentElement.classList.remove('dark');
    }, []);
    (0, react_1.useEffect)(() => {
        if (contextMode) {
            setMode(contextMode);
            setModeState(contextMode);
        }
    }, [contextMode, setMode, setModeState]);
    return [mode, setModeState, toggleMode];
};
exports.useThemeMode = useThemeMode;
