"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Modal = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const react_dom_1 = require("react-dom");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const window_exists_1 = __importDefault(require("../../helpers/window-exists"));
const hooks_1 = require("../../hooks");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const ModalBody_1 = require("./ModalBody");
const ModalContext_1 = require("./ModalContext");
const ModalFooter_1 = require("./ModalFooter");
const ModalHeader_1 = require("./ModalHeader");
const ModalComponent = ({ children, className, dismissible = false, onClose, popup, position = 'center', root, show, size = '2xl', theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.modal, customTheme);
    // Declare a ref to store a reference to a div element.
    const containerRef = (0, react_1.useRef)(null);
    // If the current value of the ref is falsy (e.g. null), set it to a new div
    // element.
    if (!containerRef.current) {
        containerRef.current = document.createElement('div');
    }
    // If the current value of the ref is not already a child of the root element,
    // append it or replace its parent.
    if (containerRef.current.parentNode !== root && (0, window_exists_1.default)()) {
        root = root || document.body;
        root.appendChild(containerRef.current);
    }
    (0, react_1.useEffect)(() => {
        return () => {
            const container = containerRef.current;
            // If a container exists on unmount, it is removed from the DOM and
            // garbage collected.
            if (container) {
                container.parentNode?.removeChild(container);
                containerRef.current = null;
            }
        };
    }, []);
    (0, hooks_1.useKeyDown)('Escape', () => {
        if (dismissible && onClose) {
            onClose();
        }
    });
    const handleOnClick = (e) => {
        if (dismissible && e.target === e.currentTarget && onClose) {
            onClose();
        }
    };
    return (0, react_dom_1.createPortal)((0, jsx_runtime_1.jsx)(ModalContext_1.ModalContext.Provider, { value: { popup, onClose }, children: (0, jsx_runtime_1.jsx)("div", { "aria-hidden": !show, "data-testid": "modal", onClick: handleOnClick, role: "dialog", className: (0, classnames_1.default)(theme.root.base, theme.root.positions[position], show ? theme.root.show.on : theme.root.show.off, className), ...props, children: (0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(theme.content.base, theme.root.sizes[size]), children: (0, jsx_runtime_1.jsx)("div", { className: theme.content.inner, children: children }) }) }) }), containerRef.current);
};
ModalComponent.displayName = 'Modal';
ModalHeader_1.ModalHeader.displayName = 'Modal.Header';
ModalBody_1.ModalBody.displayName = 'Modal.Body';
ModalFooter_1.ModalFooter.displayName = 'Modal.Footer';
exports.Modal = Object.assign(ModalComponent, { Header: ModalHeader_1.ModalHeader, Body: ModalBody_1.ModalBody, Footer: ModalFooter_1.ModalFooter });
