"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatingAdvanced = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const RatingAdvanced = ({ children, className, percentFilled = 0, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.rating.advanced, customTheme);
    return ((0, jsx_runtime_1.jsxs)("div", { className: (0, classnames_1.default)(theme.base, className), ...props, children: [(0, jsx_runtime_1.jsx)("span", { className: theme.label, children: children }), (0, jsx_runtime_1.jsx)("div", { className: theme.progress.base, children: (0, jsx_runtime_1.jsx)("div", { className: theme.progress.fill, "data-testid": "flowbite-rating-fill", style: { width: `${percentFilled}%` } }) }), (0, jsx_runtime_1.jsx)("span", { className: theme.progress.label, children: `${percentFilled}%` })] }));
};
exports.RatingAdvanced = RatingAdvanced;
