"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sidebar = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const SidebarCollapse_1 = __importDefault(require("./SidebarCollapse"));
const SidebarContext_1 = require("./SidebarContext");
const SidebarCTA_1 = __importDefault(require("./SidebarCTA"));
const SidebarItem_1 = __importDefault(require("./SidebarItem"));
const SidebarItemGroup_1 = __importDefault(require("./SidebarItemGroup"));
const SidebarItems_1 = __importDefault(require("./SidebarItems"));
const SidebarLogo_1 = __importDefault(require("./SidebarLogo"));
const SidebarComponent = ({ children, collapseBehavior = 'collapse', collapsed: isCollapsed = false, theme: customTheme = {}, className, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.sidebar, customTheme);
    return ((0, jsx_runtime_1.jsx)(SidebarContext_1.SidebarContext.Provider, { value: { isCollapsed }, children: (0, jsx_runtime_1.jsx)("aside", { "aria-label": "Sidebar", hidden: isCollapsed && collapseBehavior === 'hide', className: (0, classnames_1.default)(theme.root.base, theme.root.collapsed[isCollapsed ? 'on' : 'off'], className), ...props, children: (0, jsx_runtime_1.jsx)("div", { className: theme.root.inner, children: children }) }) }));
};
SidebarComponent.displayName = 'Sidebar';
exports.Sidebar = Object.assign(SidebarComponent, {
    Collapse: SidebarCollapse_1.default,
    CTA: SidebarCTA_1.default,
    Item: SidebarItem_1.default,
    Items: SidebarItems_1.default,
    ItemGroup: SidebarItemGroup_1.default,
    Logo: SidebarLogo_1.default,
});
